const crypto = require("crypto");

const secret = "{{YOUR_SECRET}}";

const path = "api/v1/balance";

const method = "GET";

const data = JSON.stringify([]);

const timestamp = Date.now();

console.log({
  signature: calculate_hmac(secret, timestamp, data, path, method),
  timestamp,
});

///////////// Generate Signature Using this function.//////////////////

function calculate_hmac(secret, timestamp, body, path, method = "GET") {
  const hmac = crypto.createHmac("sha256", secret);

  // Build the message like: method + "\n" + path + "\n" + body + "\n" + timestamp + "\n"
  hmac.update(method, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(path, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(body, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(String(timestamp), "utf8");
  hmac.update("\n", "utf8");

  return hmac.digest("hex"); // lowercase hex string
}
