const crypto = require("crypto");

const secret = "{{YOUR_SECRET}}";
const path = "api/v1/payin/transactions";
const method = "POST";

const dataObj = {
  order_id: "ad3rz-23sd3sd-ad23234",
};

// Convert to JSON string
let data = JSON.stringify(dataObj);

// Millisecond timestamp
const timestamp = Date.now(); // same as floor(microtime(true) * 1000)

// Output
console.log({
  signature: calculate_hmac(secret, timestamp, data, path, method),
  timestamp,
});

///////////// Generate Signature Using this function.//////////////////

function calculate_hmac(secret, timestamp, body, path, method = "GET") {
  const hmac = crypto.createHmac("sha256", secret);

  // Build the message like: method + "\n" + path + "\n" + body + "\n" + timestamp + "\n"
  hmac.update(method, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(path, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(body, "utf8");
  hmac.update("\n", "utf8");
  hmac.update(String(timestamp), "utf8");
  hmac.update("\n", "utf8");

  return hmac.digest("hex"); // lowercase hex string
}
